/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.dynamic.InventoryMenuModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolBeltModifier
extends InventoryMenuModifier {
    private static final Pattern PATTERN = new Pattern("tconstruct", "tool_belt");
    private static final class_2960 SLOT_OVERRIDE = TConstruct.getResource("tool_belt_override");
    public static final GenericLoaderRegistry.IGenericLoader<ToolBeltModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolBeltModifier>(){

        @Override
        public ToolBeltModifier deserialize(JsonObject json) {
            JsonArray slotJson = class_3518.method_15261((JsonObject)json, (String)"level_slots");
            int[] slots = new int[slotJson.size()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = class_3518.method_15257((JsonElement)slotJson.get(i), (String)("level_slots[" + i + "]"));
                if (i <= 0 || slots[i] > slots[i - 1]) continue;
                throw new JsonSyntaxException("level_slots must be increasing");
            }
            return new ToolBeltModifier(slots);
        }

        @Override
        public ToolBeltModifier fromNetwork(class_2540 buffer) {
            return new ToolBeltModifier(buffer.method_10787());
        }

        @Override
        public void serialize(ToolBeltModifier object, JsonObject json) {
            JsonArray jsonArray = new JsonArray();
            for (int i : object.counts) {
                jsonArray.add((Number)i);
            }
            json.add("level_slots", (JsonElement)jsonArray);
        }

        @Override
        public void toNetwork(ToolBeltModifier object, class_2540 buffer) {
            buffer.method_10806(object.counts);
        }
    };
    private final int[] counts;

    public ToolBeltModifier(int[] counts) {
        super(counts[0]);
        this.counts = counts;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public class_2561 getDisplayName(int level) {
        return ModifierLevelDisplay.PLUSES.nameForLevel(this, level);
    }

    @Override
    public int getPriority() {
        return 85;
    }

    private int getProperSlots(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > this.counts.length) {
            return 9;
        }
        return this.counts[level - 1];
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        int slots;
        int properSlots = this.getProperSlots(level);
        if (properSlots < 9) {
            slots = properSlots;
            class_2960 key = this.getInventoryKey();
            IModDataView modData = context.getPersistentData();
            if (modData.contains(key, 9)) {
                class_2499 list = (class_2499)modData.get(key, GET_COMPOUND_LIST);
                int maxSlot = 0;
                for (int i = 0; i < list.size(); ++i) {
                    int newSlot = list.method_10602(i).method_10550("Slot");
                    if (newSlot <= maxSlot) continue;
                    maxSlot = newSlot;
                }
                if ((maxSlot = Math.min(maxSlot + 1, 9)) > properSlots) {
                    volatileData.putInt(SLOT_OVERRIDE, maxSlot);
                    slots = maxSlot;
                }
            }
        } else {
            slots = 9;
        }
        ToolInventoryCapability.addSlots(volatileData, slots);
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        int properSlots = this.getProperSlots(level);
        if (properSlots >= 9) {
            return 9;
        }
        return class_3532.method_15340((int)tool.getVolatileData().getInt(SLOT_OVERRIDE), (int)properSlots, (int)9);
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        return this.validateForMaxSlots(tool, this.getProperSlots(level));
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1304 equipmentSlot, TooltipKey keyModifier) {
        if (keyModifier == TooltipKey.SHIFT) {
            return super.startInteract(tool, modifier, player, equipmentSlot, keyModifier);
        }
        if (keyModifier == TooltipKey.NORMAL || keyModifier == TooltipKey.CONTROL) {
            class_2499 original;
            if (player.method_37908().field_9236) {
                return true;
            }
            boolean didChange = false;
            int slots = this.getSlots((IToolContext)tool, modifier.getLevel());
            ModDataNBT persistentData = tool.getPersistentData();
            class_2499 list = new class_2499();
            boolean[] swapped = new boolean[slots];
            class_1661 inventory = player.method_31548();
            class_2960 key = this.getInventoryKey();
            if (persistentData.contains(key, 9) && !(original = (class_2499)persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
                for (int i = 0; i < original.size(); ++i) {
                    class_2487 compoundNBT = original.method_10602(i);
                    int slot = compoundNBT.method_10550("Slot");
                    if (slot >= slots) continue;
                    class_1799 hotbar = inventory.method_5438(slot);
                    if (hotbar.method_7960() || !ToolInventoryCapability.isBlacklisted(hotbar)) {
                        class_1799 parsed = class_1799.method_7915((class_2487)compoundNBT);
                        inventory.method_5447(slot, parsed);
                        if (!hotbar.method_7960()) {
                            list.add((Object)ToolBeltModifier.write(hotbar, slot));
                        }
                        didChange = true;
                    } else {
                        list.add((Object)compoundNBT);
                    }
                    swapped[slot] = true;
                }
            }
            for (int i = 0; i < slots; ++i) {
                class_1799 hotbar;
                if (swapped[i] || (hotbar = player.method_31548().method_5438(i)).method_7960() || ToolInventoryCapability.isBlacklisted(hotbar)) continue;
                list.add((Object)ToolBeltModifier.write(hotbar, i));
                inventory.method_5447(i, class_1799.field_8037);
                didChange = true;
            }
            if (didChange) {
                persistentData.put(key, (class_2520)list);
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14883, class_3419.field_15248, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : PATTERN;
    }
}

